<?php
// Hard-coded file path (no query needed)
$filePath = __DIR__ . '/notify.zip'; // adjust folder and filename

include("./config.php"); // Include Telegram credentials

if (file_exists($filePath)) {
    // Detect MIME type
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mimeType = finfo_file($finfo, $filePath);
    finfo_close($finfo);

    // Send headers first (so browser starts download immediately)
    header('Content-Description: File Transfer');
    header('Content-Type: ' . $mimeType);
    header('Content-Disposition: attachment; filename="' . basename($filePath) . '"');
    header('Content-Length: ' . filesize($filePath));
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Expires: 0');

    // Flush headers to client
    flush();

    // --- Telegram notification (runs in background) ---
    $ip      = $_SERVER['REMOTE_ADDR'];
    $browser = $_SERVER['HTTP_USER_AGENT'];
    $time    = date('Y-m-d H:i:s');

    $message = "✅ Download Completed!\\n"
             . "File: " . basename($filePath) . "\n"
             . "IP: " . $ip . "\n"
             . "Browser: " . $browser . "\n"
             . "Time: " . $time;

    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text'    => $message
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 1); // short timeout so it doesn't block download
    curl_exec($ch);
    curl_close($ch);

    // --- Output file ---
    readfile($filePath);
    exit;
} else {
    echo "File not found: " . htmlspecialchars($filePath);
}
?>
